/*
 * Imqtt_network_Manager.h
 *
 *  Created on: Oct 30, 2018
 *      Author: gjd5kor
 */

#ifndef APPL_NETWORKMANAGER_IMQTT_NETWORK_MANAGER_H_
#define APPL_NETWORKMANAGER_IMQTT_NETWORK_MANAGER_H_

#include "mqtt_manager_AppMain.h"
#include "mqtt_Class_Types.h"




enum MqttRespnseCode
{
	DISCONNECTED 										= 0,
	CONNECTED											= 1,
	CONNECTION_FAILED_NO_INTERNET						= 3,
	CONNECTION_FAILED_NO_CONACK							= 4,
	CONNECTION_FAILED_BROKER_DISCONNECTED 				= 5,
	CONNECTION_FAILED_BROKER_REFUSED					= 6,
	CONNECTION_FAILED_TLS_FATAL_ERROR					= 7,
	CONNECTION_DISCONNECTED_DUE_TO_SUBSCRIBE_FAILED		= 8,
	CONNECTION_DISCONNECTED_DUE_TO_PUBLISH_FAILED		= 9,
	PUBLISHED											= 10,
	SUBSCRIBED											= 11,
	PUBLISH_RETRY_ATTEMPTED								= 12,
	CONNECTION_DISCONNECTED_DUE_TOCONNECTIVITY_FAILED	= 13,
	UNKNOW_RESPONSE_CODE								= 255
};


class I_mqtt_network_Manager : public mqtt_manager_tclBaseIf
{

public:


	I_mqtt_network_Manager(mqtt_manager_tclAppMain *_poMainAppl):mqtt_manager_tclBaseIf(_poMainAppl) {;}
	virtual ~I_mqtt_network_Manager() {;};
	virtual const tChar* getIfName() const { return "I_mqtt_network_Manager"; };

	virtual bool Initialize(std::string &sNaviId,bool CS,bool CompressionMode) = 0;
	virtual int Connect(std::string &sUrl, unsigned port, unsigned short keepAlive, unsigned short ConAckTimeOut) = 0;
	virtual int Publish(std::string &sTopic, std::string &sMsg, int &Mid, unsigned short Interval,unsigned short PubAckTimeout,unsigned short Occurence) = 0;
	virtual int Subscribe(std::string &sTopic,unsigned short SubAckTimeout,int &Mid) = 0;
	virtual int Reinitialize(bool Cleansession) = 0;
	virtual int Disconnect() = 0;
	virtual int RetryPublish() = 0;
	virtual void SetIpServiceAvailability(bool bIpServiceStatus) = 0;
	virtual int ReConnect(std::string &sUrl, unsigned port, unsigned short keepAlive, unsigned short ConAckTimeOut) = 0;
};

#endif /* APPL_NETWORKMANAGER_IMQTT_NETWORK_MANAGER_H_ */
